import java.awt.Panel;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Label;
import java.awt.Font;
import java.awt.Color;
import java.awt.Dimension;


public class FontLabel extends Panel {
    Font    m_Font;
    String  m_Text;
    int m_iSizeX;
    int m_iSizeY;
    int m_iSize;
    public FontLabel(String text,String name,int iStyle,int iSize,int iSizeX,int iSizeY) {
        m_Font=new Font(name,iStyle,iSize);
        m_iSizeX = iSizeX;
        m_iSizeY = iSizeY;
        m_iSize = iSize;
        m_Text = text;
    }
    public void paint(Graphics g) {
        g.setFont(m_Font);
        g.setColor(Color.black);
        g.drawString(m_Text,0,m_iSizeY/2+m_iSize/2);
   		Rectangle frame=bounds();
    }
    public void setText(String text) {
        m_Text = text;
        repaint();
    }
    public Dimension preferredSize() {
        return (new Dimension(m_iSizeX,m_iSizeY));
    };
    public Dimension minimumSize() {
        return (new Dimension(m_iSizeX,m_iSizeY));
    };

}
